/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.vo;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.vo.MosPVo;

import jp.mosp.system.dto.MCodeDto;

public class YukyuInformationCardVo extends MosPVo {	

	private static final long serialVersionUID = 8784848856294588759L;

	//URLAJSt@CACSSt@C
	private static final String RETURN_URL = "/jsp/system/yukyuInformationCard.jsp";
	private static final String EXTRA_JS   = "/pub/system/js/yukyuInformationCard.js";
	private static final String EXTRA_CSS  = "/pub/system/css/yukyuInformationCard.css";

	//ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_PAID_HOLIDAY_MASTER;
	//ʂŎg
	public final String SUB_TITLE1 = CommonConst.NAM_CARRIED_FORWARD + CommonConst.NAM_PROCESS + CommonConst.NAM_SET_UP;
	public final String SUB_TITLE2 = CommonConst.NAM_PAID_HOLIDAY + CommonConst.NAM_SUPPLY + CommonConst.NAM_CONDITION;

	//萔
	public static final int MODE_UPDATE = 1;

	//p[^[
	public static final String PRM_PLT_CF_MONTH	= "pltCFMonth";
	public static final String PRM_TXT_CF_DAYS 	= "txtCFDays";
	public static final String PRM_PLT_CF_KBN		= "pltCFKbn";

	public static final String PRM_TXT_STANDARD 	= "txtStandard";
	public static final String PRM_TXT_DAYS 		= "txtDays";
	public static final String PRM_TXT_INFO		= "txtInfo";

	//tB[h
	private String  	pltCFMonth		;	
	private String 		txtCFDays		;	
	private String  	pltCFKbn		;	
	private String[]  	aryTxtStandard	;
	private String[]  	aryTxtDays		;
	private String[]  	aryTxtInfo		;

	//v_EXg
	public String[][] aryPltCFKbn;
	public String[][] aryPltCFMonth;

	//[h(1FXV)
	private int mode;

	//tB[hyѐ
	public static final String NAM_CF_MONTH	= CommonConst.NAM_CARRIED_FORWARD + CommonConst.NAM_PROCESS + CommonConst.NAM_MONTH;
	public static final String NAM_CF_DAYS 	= CommonConst.NAM_CARRIED_FORWARD + CommonConst.NAM_NUMBER_OF_DAYS;
	public static final String NAM_CF_KBN 	= CommonConst.NAM_CARRIED_FORWARD + CommonConst.NAM_COMMON_TYPE;
	public static final String NAM_STANDARD	= CommonConst.NAM_SUPPLY + CommonConst.NAM_CONDITION;
	public static final String NAM_DAYS 		= CommonConst.NAM_SUPPLY + CommonConst.NAM_NUMBER_OF_DAYS;
	public static final String NAM_INFO 		= CommonConst.NAM_EXPLANATION;

	public static final int LEN_CF_MONTH		= 2;
	public static final int LEN_CF_DAYS 		= 2;
	public static final int LEN_STANDARD		= 2;
	public static final int LEN_DAYS 			= 2;
	public static final int LEN_INFO 			= 7;

	/**
	 * RXgN^
	 */
	public YukyuInformationCardVo(){
		super();
		mode = 0;
		setExtraCss	(EXTRA_CSS);
		addExtraJs	(EXTRA_JS);
		setRetUrl	(RETURN_URL);
		pltCFMonth	= "";
		txtCFDays		= "";
		pltCFKbn			= "";
		aryTxtStandard	= new String[0];
		aryTxtDays		= new String[0];
		aryTxtInfo		= new String[0];
	}

	/**
	 * lݒ
	 */	
	public void setDefaultValues(){
		aryTxtStandard = new String[20];
		for (int i = 0; i < aryTxtStandard.length; i++) {
			aryTxtStandard[i] = "";
		}
		aryTxtDays = new String[20];
		for (int i = 0; i < aryTxtDays.length; i++) {
			aryTxtDays[i] = "";
		}
		aryTxtInfo = new String[20];
		for (int i = 0; i < aryTxtInfo.length; i++) {
			aryTxtInfo[i] = "";
		}
	}

	/**
	 * p[^ݒ
	 */
	public void setParams(HttpServletRequest request){
		pltCFMonth		= request.getParameter(PRM_PLT_CF_MONTH);
		txtCFDays 		= request.getParameter(PRM_TXT_CF_DAYS);
		pltCFKbn 		= request.getParameter(PRM_PLT_CF_KBN);
		aryTxtStandard	= request.getParameterValues(PRM_TXT_STANDARD);
		aryTxtDays 		= request.getParameterValues(PRM_TXT_DAYS);
		aryTxtInfo 		= request.getParameterValues(PRM_TXT_INFO);
	}

	/**
	 * tB[hݒ
	 * @param listYukyuInfo Lx񃊃Xg
	 */
	public void setFields(List listYukyuInfo) throws MospException{
		//Xg̐ݒ
		list = listYukyuInfo;
		// f[^̎擾
		count = 20;
		// z̏
		aryTxtStandard	= new String[count];
		aryTxtDays		= new String[count];
		aryTxtInfo		= new String[count];
		for (int i = 0; i < 20 ; i++) {
			aryTxtStandard[i] = "";
			aryTxtDays[i] = "";
			aryTxtInfo[i] = "";
		}
		//f[^̐ݒ		
		int i = 0;
		Iterator it = listYukyuInfo.iterator();
		while (it.hasNext()){
			MCodeDto dto = (MCodeDto)it.next();
			aryTxtStandard[i]	= escapeHTML(dto.getTCode());
			aryTxtDays[i] 		= escapeHTML(dto.getTChange());
			aryTxtInfo[i] 		= escapeHTML(dto.getTName());
			i++;
		}
	}

	/**
	 * tB[hݒ(DTOVOɃZbg)
	 * @param dto Xg
	 */
	public void setFieldsCFMonth(MCodeDto dto){
		pltCFMonth = dto.getTChange();		
	}

	public void setFieldsCFDay(MCodeDto dto){
		txtCFDays = dto.getTChange();		
	}

	public void setFieldsCFDivision(MCodeDto dto){
		pltCFKbn = dto.getTChange();
	}

	/**
	 * tB[hݒ(DTOɑ΂VÕZbg)
	 * @param dto ݒΏDTO
	 */
	public void setDtoFieldsCFMonth(MCodeDto dto) {
		dto.setTId(CommonConst.NAM_PAID_HOLIDAY);
		dto.setTCode(CommonConst.NAM_CARRIED_FORWARD + CommonConst.NAM_MONTH);
		dto.setTChange(pltCFMonth);
	}

	public void setDtoFieldsCFDay(MCodeDto dto) {
		dto.setTId(CommonConst.NAM_PAID_HOLIDAY);
		dto.setTCode(CommonConst.NAM_CARRIED_FORWARD + CommonConst.NAM_NUMBER_OF_DAYS);
		dto.setTChange(txtCFDays);
	}

	public void setDtoFieldsCFDivision(MCodeDto dto) {
		dto.setTId(CommonConst.NAM_PAID_HOLIDAY);
		dto.setTCode(CommonConst.NAM_CARRIED_FORWARD + CommonConst.NAM_COMMON_TYPE);
		dto.setTName(CommonConst.TNM_CARRY_OVER);
		dto.setTChange(pltCFKbn);
	}

	public void setDtoFields(List<MCodeDto> listCode) {
		for (int i = 0; i < aryTxtStandard.length; i++) {
			MCodeDto dto = new MCodeDto();
			dto.setTId(CommonConst.NAM_PAID_HOLIDAY + CommonConst.NAM_SUPPLY);
			if (!aryTxtStandard[i].equals("") && aryTxtStandard[i].length() < 2) {
				aryTxtStandard[i] = "0" + aryTxtStandard[i] ;
			}
			dto.setTCode(aryTxtStandard[i]);
			dto.setTName(aryTxtInfo[i]);
			dto.setTChange(aryTxtDays[i]);
			listCode.add(dto);
		}
	}

	/**
	 * tB[h̑ÓmFiLxɏj
	 * @throws MospException
	 */
	public void validate() throws MospException {
		//ÓmFJn
		startValidation();
		//K{mF
		checkRequired(txtCFDays		, NAM_CF_DAYS	, PRM_TXT_CF_DAYS	);
		checkRequired(pltCFKbn		, NAM_CF_KBN	, PRM_PLT_CF_KBN	);
		//񒷊mF
		checkLength(txtCFDays	, LEN_CF_DAYS	, NAM_CF_DAYS	, PRM_TXT_CF_DAYS	);
		//^CvmF(p)
		checkNumber(txtCFDays	, NAM_CF_DAYS	, PRM_TXT_CF_DAYS);
		for (int i = 0; i < aryTxtStandard.length; i++) {
			if (!aryTxtStandard[i].equals("")) {
				//^CvmF(p)
				checkNumber(aryTxtStandard[i], 		NAM_STANDARD,					i, 	PRM_TXT_STANDARD);
				checkLength(aryTxtStandard[i], 		LEN_STANDARD,	NAM_STANDARD,	i, 	PRM_TXT_STANDARD);
			} else {
				if (!aryTxtDays[i].equals("")) {
					//K{mF
					checkRequired(aryTxtStandard[i],NAM_STANDARD, 					i, 	PRM_TXT_STANDARD);
					checkRequired(aryTxtInfo[i], 	NAM_INFO, 						i, 	PRM_TXT_INFO);
					//^CvmF(p)
					checkNumber(aryTxtStandard[i], 	NAM_STANDARD, 					i, 	PRM_TXT_STANDARD);
					checkNumber(aryTxtDays[i], 		NAM_DAYS,  						i,	PRM_TXT_DAYS);
					//񒷊mF
					checkLength(aryTxtStandard[i], 	LEN_STANDARD,	NAM_STANDARD,	i,  PRM_TXT_STANDARD);
					checkLength(aryTxtDays[i], 		LEN_DAYS, 		NAM_DAYS, 	 	i,	PRM_TXT_DAYS);
					checkLength(aryTxtInfo[i], 		LEN_INFO, 		NAM_INFO, 	 	i,	PRM_TXT_INFO);
				}
				if (!aryTxtInfo[i].equals("")) {
					//K{mF
					checkRequired(aryTxtStandard[i],NAM_STANDARD, 					i, 	PRM_TXT_STANDARD);
					checkRequired(aryTxtDays[i], 	NAM_DAYS, 						i,	PRM_TXT_DAYS);
					//^CvmF(p)
					checkNumber(aryTxtStandard[i], 	NAM_STANDARD,  					i,	PRM_TXT_STANDARD);
					checkNumber(aryTxtDays[i], 		NAM_DAYS, 						i, 	PRM_TXT_DAYS);
					//񒷊mF
					checkLength(aryTxtStandard[i], 	LEN_STANDARD,  	NAM_STANDARD, 	i,	PRM_TXT_STANDARD);
					checkLength(aryTxtDays[i], 		LEN_DAYS,  		NAM_DAYS, 		i,	PRM_TXT_DAYS);
					checkLength(aryTxtInfo[i], 		LEN_INFO,  		NAM_INFO, 		i,	PRM_TXT_INFO);
				}
			}
		}		// ÓmFI
		endValidation();
	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String  getDirectJs(Class cls) throws IllegalAccessException{
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();		
	}

	//ANZT\bh
	public String[] getEscAryTxtStandard()	{ return aryTxtStandard.clone()	; }
	public String[] getEscAryTxtDays()		{ return aryTxtDays.clone()		; }
	public String[] getEscAryTxtInfo()		{ return aryTxtInfo.clone()		; }

	public String getPltCFMonth()	{ return pltCFMonth	; }
	public String getTxtCFDays() 	{ return txtCFDays	; }
	public String getPltCFKbn()		{ return pltCFKbn	; }

	public String getEscPltCFMonth() 	{ return escapeHTML(pltCFMonth)	; }
	public String getEscTxtCFDays()		{ return escapeHTML(txtCFDays)	; }
	public String getEscPltCFKbn()		{ return escapeHTML(pltCFKbn)	; }

	public void setPltCFMonth		(String pltCFMonth	){ this.pltCFMonth 	= pltCFMonth	; }
	public void setTxtCFDays		(String txtCFDays	){ this.txtCFDays 	= txtCFDays		; }
	public void setPltCFKbn		(String pltCFKbn	){ this.pltCFKbn 	= pltCFKbn		; }

	public void setMode(int mode) { this.mode = mode; }
	public int getMode() { return mode; }

}
